/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTableModel;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.wcl.components.table.ITableSelectionModel;
import com.ibm.ps.wcl.components.table.WTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableSelectionModelImpl
implements ITableSelectionModel {
    public static final int NO_SELECT = -1;
    private boolean valueIsAdjusting;
    private List listeners;
    private PmTableModel pmTableModel;
    private WTable wTable;
    private int selectionMode = 2;
    private int anchorIndex;
    private int leadIndex;
    private static final String TRACE_MASKD = "XPMTSMID";
    private static final String TRACE_MASKF = "XPMTSMIF";
    private static final String TRACE_MASKT = "XPMTSMIT";

    public TableSelectionModelImpl(PmTableModel pmTableModel) {
        this.pmTableModel = pmTableModel;
        this.listeners = new ArrayList();
    }

    public void setWTable(WTable wTable) {
        this.wTable = wTable;
    }

    public int getMinSelectionIndex() {
        Trace.trace(TRACE_MASKT, "TSMI.getMinSelectionIndex()");
        if (this.selectionMode == -1) {
            return -1;
        }
        int[] sel = this.getSelectedRows();
        if (sel.length == 0) {
            return -1;
        }
        return sel[0];
    }

    public void setSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "TSMI.setSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.wTable != null) {
            index0 = this.wTable.getModelRowIndex(index0);
            index1 = this.wTable.getModelRowIndex(index1);
            Trace.trace(TRACE_MASKT, "new index0: " + index0 + " , new index1:" + index1);
        }
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearAll();
            }
            int[] currentSel = this.getSelectedRows();
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSel = new int[++newSelIntervalSize];
            int i = 0;
            while (i < newSelIntervalSize) {
                newSel[i] = index0 == index1 ? index0 : (index0 < index1 ? index0 + i : index1 + i);
                ++i;
            }
            if (!Arrays.equals(currentSel, newSel)) {
                this.anchorIndex = index0;
                this.leadIndex = index1;
                this.pmTableModel.setSelected(newSel);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
        }
    }

    public void removeSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "TSMI.removeSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.wTable != null) {
            index0 = this.wTable.getModelRowIndex(index0);
            index1 = this.wTable.getModelRowIndex(index1);
            Trace.trace(TRACE_MASKT, "new index0: " + index0 + " , new index1:" + index1);
        }
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
            }
            int[] currentSel = this.getSelectedRows();
            int remSelIntervalSize = index0 - index1;
            if (remSelIntervalSize < 0) {
                remSelIntervalSize *= -1;
            }
            Trace.trace(TRACE_MASKF, "currentSel.length: " + currentSel.length);
            int[] selSubtraction = new int[++remSelIntervalSize];
            int i = 0;
            while (i < selSubtraction.length) {
                selSubtraction[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
                ++i;
            }
            Trace.trace(TRACE_MASKF, "selSubtraction.length: " + selSubtraction.length);
            int uniqueEntries = currentSel.length;
            int i2 = 0;
            while (i2 < selSubtraction.length) {
                boolean found = false;
                int j = 0;
                while (j < currentSel.length) {
                    if (currentSel[j] == selSubtraction[i2]) {
                        found = true;
                        j = currentSel.length;
                    }
                    ++j;
                }
                if (found) {
                    --uniqueEntries;
                }
                ++i2;
            }
            int[] newSelection = new int[uniqueEntries];
            uniqueEntries = 0;
            int i3 = 0;
            while (i3 < currentSel.length) {
                boolean found = false;
                int j = 0;
                while (j < selSubtraction.length) {
                    if (currentSel[i3] == selSubtraction[j]) {
                        found = true;
                        j = selSubtraction.length;
                    }
                    ++j;
                }
                if (!found) {
                    newSelection[uniqueEntries++] = currentSel[i3];
                }
                ++i3;
            }
            Arrays.sort(newSelection);
            Trace.trace(TRACE_MASKF, "newSelection.length: " + newSelection.length);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.pmTableModel.setSelected(newSelection);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
            Trace.trace(TRACE_MASKF, "new selection values:");
            int i4 = 0;
            while (i4 < newSelection.length) {
                Trace.trace(TRACE_MASKF, "newSelection[" + i4 + "]: " + newSelection[i4]);
                ++i4;
            }
        }
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        Trace.trace(TRACE_MASKT, "TSMI.insertIndexInterval(" + index + "," + length + "," + before + ")");
        Trace.trace(TRACE_MASKF, "TSMI -- Not implemented!! --");
    }

    public void addSelectionInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "TSMI.addSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.wTable != null) {
            index0 = this.wTable.getModelRowIndex(index0);
            index1 = this.wTable.getModelRowIndex(index1);
        }
        if (this.selectionMode != -1) {
            int[] currentSel = this.getSelectedRows();
            if (this.selectionMode == 0) {
                index1 = index0;
                this.clearAll();
                currentSel = new int[]{};
            }
            Trace.trace(TRACE_MASKF, "currentSel.length: " + currentSel.length);
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSelAddition = new int[++newSelIntervalSize];
            int i = 0;
            while (i < newSelAddition.length) {
                newSelAddition[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
                ++i;
            }
            int uniqueEntries = currentSel.length;
            int i2 = 0;
            while (i2 < newSelAddition.length) {
                boolean found = false;
                int j = 0;
                while (j < currentSel.length) {
                    if (currentSel[j] == newSelAddition[i2]) {
                        found = true;
                        j = currentSel.length;
                    }
                    ++j;
                }
                if (!found) {
                    ++uniqueEntries;
                }
                ++i2;
            }
            int[] newSelection = new int[uniqueEntries];
            System.arraycopy(currentSel, 0, newSelection, 0, currentSel.length);
            uniqueEntries = currentSel.length;
            int i3 = 0;
            while (i3 < newSelAddition.length) {
                boolean found = false;
                int j = 0;
                while (j < currentSel.length) {
                    if (currentSel[j] == newSelAddition[i3]) {
                        found = true;
                        j = currentSel.length;
                    }
                    ++j;
                }
                if (!found) {
                    newSelection[uniqueEntries++] = newSelAddition[i3];
                }
                ++i3;
            }
            Arrays.sort(newSelection);
            this.anchorIndex = index0;
            this.leadIndex = index1;
            if (newSelection.length != currentSel.length) {
                this.pmTableModel.setSelected(newSelection);
                ListSelectionEvent e = new ListSelectionEvent(this, index0, index1, this.valueIsAdjusting);
                Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
                while (iterator.hasNext()) {
                    ListSelectionListener listener = (ListSelectionListener)iterator.next();
                    listener.valueChanged(e);
                }
            }
            Trace.trace(TRACE_MASKF, "new selection values:");
        }
    }

    public void setAnchorSelectionIndex(int index) {
        Trace.trace(TRACE_MASKT, "TSMI.setAnchorSelectionIndex(" + index + ")");
        this.anchorIndex = index;
    }

    public int getMaxSelectionIndex() {
        Trace.trace(TRACE_MASKT, "TSMI.getMaxSelectionIndex()");
        if (this.selectionMode == -1) {
            return -1;
        }
        int[] sel = this.getSelectedRows();
        if (sel.length == 0) {
            return -1;
        }
        return sel[sel.length - 1];
    }

    public void setLeadSelectionIndex(int index) {
        Trace.trace(TRACE_MASKT, "TSMI.setLeadSelectionIndex(" + index + ")");
        this.leadIndex = index;
    }

    public int getAnchorSelectionIndex() {
        Trace.trace(TRACE_MASKT, "TSMI.getAnchorSelectionIndex()");
        return this.anchorIndex;
    }

    public boolean isSelectionEmpty() {
        Trace.trace(TRACE_MASKT, "TSMI.isSelectionEmpty()");
        return this.getSelectedRows().length == 0;
    }

    public int getLeadSelectionIndex() {
        Trace.trace(TRACE_MASKT, "TSMI.getLeadSelectionIndex()");
        return this.leadIndex;
    }

    public void removeIndexInterval(int index0, int index1) {
        Trace.trace(TRACE_MASKT, "TSMI.removeIndexInterval(" + index0 + "," + index1 + ")");
        Trace.trace(TRACE_MASKF, "TSMI -- Not implemented!! --");
        this.anchorIndex = index0;
        this.leadIndex = index1;
    }

    public void clearSelection() {
        Trace.trace(TRACE_MASKT, "TSMI.clearSelection()");
        this.clearAll();
    }

    public boolean getValueIsAdjusting() {
        Trace.trace(TRACE_MASKT, "TSMI.getValueIsAdjusting()");
        return this.valueIsAdjusting;
    }

    public int getSelectionMode() {
        Trace.trace(TRACE_MASKT, "TSMI.getSelectionMode()");
        return this.selectionMode;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        Trace.trace(TRACE_MASKT, "TSMI.setValueIsAdjusting(" + valueIsAdjusting + ")");
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        Trace.trace(TRACE_MASKT, "TSMI.removeListSelectionListener(" + listener + ")");
        this.listeners.remove(listener);
    }

    public void setSelectionMode(int selectionMode) {
        Trace.trace(TRACE_MASKT, "TSMI.setSelectionMode(" + selectionMode + ")");
        switch (selectionMode) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = selectionMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        Trace.trace(TRACE_MASKT, "TSMI.addListSelectionListener(" + listener + ")");
        this.listeners.add(listener);
    }

    public int[] getSelectedRows() {
        Trace.trace(TRACE_MASKT, "TSMI.getSelectedRows()");
        if (this.selectionMode == -1) {
            return new int[0];
        }
        int[] sel = this.pmTableModel.getSelected();
        if (sel == null) {
            return new int[0];
        }
        if (this.wTable != null) {
            int i = 0;
            while (i < sel.length) {
                ++i;
            }
        }
        return sel;
    }

    public int getSelectedRowCount() {
        Trace.trace(TRACE_MASKT, "TSMI.getSelectedRowCount()");
        if (this.selectionMode == -1) {
            return 0;
        }
        return this.getSelectedRows().length;
    }

    public boolean isSelectedIndex(int index) {
        Trace.trace(TRACE_MASKT, "TSMI.isSelectedIndex(" + index + ")");
        int[] sel = this.getSelectedRows();
        int i = 0;
        while (i < sel.length) {
            if (sel[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int[] getSelectedModelRows() {
        Trace.trace(TRACE_MASKT, "TSMI.getSelectedModelRows()");
        if (this.selectionMode == -1) {
            return new int[0];
        }
        int[] sel = this.pmTableModel.getSelected();
        if (sel == null) {
            return new int[0];
        }
        return sel;
    }

    public int getSelectedModelRowCount() {
        Trace.trace(TRACE_MASKT, "TSMI.getSelectedModelRowCount()");
        if (this.selectionMode == -1) {
            return 0;
        }
        return this.getSelectedModelRows().length;
    }

    public boolean isSelectedModelIndex(int index) {
        Trace.trace(TRACE_MASKT, "TSMI.isSelectedModelIndex(" + index + ")");
        if (this.selectionMode == -1) {
            return false;
        }
        int[] sel = this.pmTableModel.getSelected();
        if (sel == null) {
            return false;
        }
        int i = 0;
        while (i < sel.length) {
            if (sel[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void selectAll() {
        Trace.trace(TRACE_MASKT, "TSMI.selectAll()");
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                if (this.pmTableModel.getRowCount() > 0) {
                    this.pmTableModel.setSelected(new int[]{0});
                }
            } else {
                int[] newSel = new int[this.pmTableModel.getRowCount()];
                int i = 0;
                while (i < newSel.length) {
                    newSel[i] = i;
                    ++i;
                }
                this.pmTableModel.setSelected(newSel);
            }
            ListSelectionEvent e = new ListSelectionEvent(this, 0, this.pmTableModel.getRowCount(), this.valueIsAdjusting);
            Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
            while (iterator.hasNext()) {
                ListSelectionListener listener = (ListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
        }
    }

    public void clearAll() {
        Trace.trace(TRACE_MASKT, "TSMI.clearAll()");
        if (this.selectionMode != -1) {
            this.pmTableModel.setSelected(new int[0]);
            ListSelectionEvent e = new ListSelectionEvent(this, 0, -1, this.valueIsAdjusting);
            Iterator iterator = ((List)((ArrayList)this.listeners).clone()).iterator();
            while (iterator.hasNext()) {
                ListSelectionListener listener = (ListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
        }
    }
}

